/*
 * 05/10/2006 : debugger 
 * 07/10/2006 : first code executed => ROM checksum error
 * 08/10/2006 : _ checksum patched => MMU test pass but no RAM found
 *              _ added breakpoint
 * 09/10/2006 : _ added MMU debug
 *              _ corrected mmu & Long Write
 *              _ added lock to 0 context when in supervisor mode (for mmu use)
 *              _ now crash on first RTS. 0xFE06E0 (stack translation error?)
 *              _ => corrected HWReset (bad ssp)
 *              _ fail for VIA test 
                _ FE08A2 
                _ ROM was not broken, MemInit() was...
                _ corrected screen
                _ Now go graphical mode => IO Board error code 50
                  (normal, VIA are not emulated yet).
 */
#include <allegro.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cpu/68000.h"

extern void            MemInit(void);
extern uint16 LisaGetWDebug(uint32 address);
extern int    disass(char *buf, uint16 *inst_stream);
extern uint8* getVideoMemory(void);


void init();
void deinit();

int quit(void)
{
   if (alert("Really Quit?", NULL, NULL, "&Yes", "&No", 'y', 'n') == 1)
      return D_CLOSE;
   else
      return D_REDRAW;
}

int about(void)
{
   alert("IDLE (incomplete Draft of a Lisa Emulator)\nversion alpha 0.1 - 10/10/2006"  
   , NULL, NULL, "&OK", "&No", 'y', 'n');
      return D_REDRAW;
}

char log_box_init[60*20*4+1];
char log_box_init2[60*20*4+1];
char *log_box=log_box_init;

char mmu_box_init[0x10000];
char *mmu_box=mmu_box_init;

char disass_box[60*20*4+1];


void disass_debugger(void) {
                  
                  uint32 l_pc=pc;
                  uint16 l_inststream[256];
                  int i,j;
                  int l;
                  int inst_size;
                  char l_inst[256];
                  char addr[256];
                  // clears the text
                  disass_box[0]='\0';
                  log_box=log_box_init2;
                  for (l=0;l<20;l++)
                  {
                      log_box[0]='\0';
                      // fills inst stream
                      for (i=0;i<32;i++)
                          l_inststream[i]=LisaGetWDebug(l_pc+i*2);
                      // 
                      sprintf(addr,"%06X ",l_pc);
                      strcat(disass_box,addr);
                      // disass one instruction
                      inst_size=disass(l_inst,l_inststream);
                      for (j=0;j<6;j++)
                      {
                          if (j<inst_size)
                             sprintf(addr,"%04X",l_inststream[j]);
                          else
                              strcpy(addr,"    ");
                          strcat (disass_box,addr);
                      }
                      // adds to box
                      strcat(disass_box,l_inst);
                      // plus a carriage return
                      strcat(disass_box,"\n");
                      l_pc+=(2*inst_size);
                  }
                  log_box=log_box_init;
     }


char registers_box[30*20*4+1];

void regs_debugger(void)
{
     char buf[256];
     registers_box[0]='\0';
     sprintf(buf,"PC=x%08X SR=x%04X\n",pc,status);
     strcat(registers_box,buf);
     sprintf(buf,"D0=x%08X A0=x%08X\n",reg[0],reg[8]);
     strcat(registers_box,buf);
     sprintf(buf,"D1=x%08X A1=x%08X\n",reg[1],reg[9]);
     strcat(registers_box,buf);
     sprintf(buf,"D2=x%08X A2=x%08X\n",reg[2],reg[10]);
     strcat(registers_box,buf);
     sprintf(buf,"D3=x%08X A3=x%08X\n",reg[3],reg[11]);
     strcat(registers_box,buf);
     sprintf(buf,"D4=x%08X A4=x%08X\n",reg[4],reg[12]);
     strcat(registers_box,buf);
     sprintf(buf,"D5=x%08X A5=x%08X\n",reg[5],reg[13]);
     strcat(registers_box,buf);
     sprintf(buf,"D6=x%08X A6=x%08X\n",reg[6],reg[14]);
     strcat(registers_box,buf);
     sprintf(buf,"D7=x%08X A7=x%08X\n",reg[7],reg[15]);
     strcat(registers_box,buf);
 }

char breakpoint_str[6*4+1];

// one cpu instruction
int step(void)
{
    log_box[0]='\0';
    CPUStep();
    disass_debugger();
    regs_debugger();
    return D_REDRAW;
}

// loop CPU instruction until PC is greater (use this for loop)
int stepover(void)
{
    uint32 savedPC=pc;
    do {
       log_box[0]='\0';
       CPUStep();
    } while (((pc<=savedPC) || (pc>savedPC+8)) && !key[KEY_SPACE]);
    while (key[KEY_SPACE]);
    disass_debugger();
    regs_debugger();
    return D_REDRAW;
}

int tobreak(void)
{
    uint32 targetPC;
    char str_alert[256];
    sscanf(breakpoint_str,"%x",&targetPC);
    sprintf(str_alert,"Go to %06x ?",targetPC);
   if (alert(str_alert, NULL, NULL, "&Yes", "&No", 'y', 'n') == 1)
   {
      do {
          log_box[0]='\0';
          CPUStep();
          } while ((pc!=targetPC) && !key[KEY_SPACE]);
          while (key[KEY_SPACE]);
          disass_debugger();
          regs_debugger();
    }
    return D_REDRAW;
}



int redraw_lisa(void)
{
    int y,x,xx;
    uint8* video=getVideoMemory();
    int mask;
    int black=makecol(0, 0, 0);
    int white=makecol(255, 255, 255);
    acquire_screen();
    for (y=0;y<360;y++)
        for (x=0;x<90;x++)
        {
            mask=0x80;
            for (xx=0;xx<8;xx++)
            {
                if ((video[x+y*90]&mask)==mask)
                   putpixel(screen,x*8+xx,y,black);
                else
                   putpixel(screen,x*8+xx,y,white);
                mask=mask>>1;
            }
        }
        release_screen();
}

int preview(void)
{
    redraw_lisa();
    while (!key[KEY_SPACE]);
    return D_REDRAW;
}


/* the first menu in the menubar */
MENU commands[] =
{
   
   { "Step \tF7", step,  NULL,      0,  NULL  },
   { "Step over\tF8", stepover,  NULL,      0,  NULL  },
   { "Go to breakpoint", tobreak,  NULL,      0,  NULL  },
   { "screen preview", preview,  NULL,      0,  NULL  },
   { "&Quit debugger (go live!) \tq",        quit,  NULL,      0,  NULL  },
   { NULL,                   NULL,  NULL,      0,  NULL  }
};

/* the help menu */
MENU helpmenu[] =
{
   
   { "&About \tF1",      about,  NULL,      0,  NULL  },
   { NULL,               NULL,  NULL,      0,  NULL  }
};

/* the main menu-bar */
MENU the_menu[] =
{
   
   { "&Commands",  NULL,   commands,          0,      NULL  },
   { "&Help",   NULL,   helpmenu,       0,      NULL  },
   { NULL,      NULL,   NULL,           0,      NULL  }
};

DIALOG the_dialog[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h) (fg)(bg) (key) (flags)     (d1) (d2)    (dp)                   (dp2) (dp3) */
   
   /* this element just clears the screen, therefore it should come before the others */
   { d_clear_proc,        0,   0,    0,    0,   0,  0,    0,      0,       0,   0,    NULL,                   NULL, NULL  },

   /* a menu bar - note how it auto-calculates its dimension if they are not given */
   { d_menu_proc,         0,   0,    0,    0,   0,  0,    0,      0,       0,   0,    the_menu,               NULL, NULL  },
   
   /* these just display text, either left aligned, centered, or right aligned */
   { d_text_proc,         0,  20,    0,    0,   0,  0,    0,      0,       0,   0,    (void *)"Lisa emulator integrated debugger",          NULL, NULL  },

   // a 60x20 char box for disass
   { d_textbox_proc,    0, 30,  480,   160,   0,  0,    0,      0,       0,   0,    (void *)disass_box,       NULL, NULL  },

   // a 60x20 char box for loging events
   { d_textbox_proc,    0, 200,  480,   152,   0,  0,    0,      0,       0,   0,    (void *)log_box,       NULL, NULL  },

   // a 30x20 char box for registers
   { d_textbox_proc,    488, 30,  232,   160,   0,  0,    0,      0,       0,   0,    (void *)registers_box,       NULL, NULL  },

   // the breakpoint
   { d_edit_proc,    488, 206,  232,   8,   0,  0,    0,      0,       6,   0,    (void *)breakpoint_str,       NULL, NULL  },

   // the mmu Entry
   { d_textbox_proc,    488, 222,  232,   130,   0,  0,    0,      0,       0,   0,    (void *)mmu_box,       NULL, NULL  },


   { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F7,   0,    (void *)step,          NULL, NULL  },
   { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F8,   0,    (void *)stepover,          NULL, NULL  },
   { d_yield_proc,        0,   0,    0,    0,   0,  0,    0,      0,       0,   0,    NULL,                   NULL, NULL  },
   { NULL,                0,   0,    0,    0,   0,  0,    0,      0,       0,   0,    NULL,                   NULL, NULL  }
};

void debugger(void)
{
     int i;
   /* set up colors */
   gui_fg_color = makecol(0, 0, 0);
   gui_mg_color = makecol(128, 128, 128);
   gui_bg_color = makecol(200, 240, 200);
   set_dialog_color (the_dialog, gui_fg_color, gui_bg_color);

   /* white color for d_clear_proc and the d_?text_procs */
   the_dialog[0].bg = makecol(255, 255, 255);
   for (i = 4; the_dialog[i].proc; i++)
      if (the_dialog[i].proc == d_text_proc ||
          the_dialog[i].proc == d_ctext_proc ||
          the_dialog[i].proc == d_rtext_proc)
         the_dialog[i].bg = the_dialog[0].bg;
   /* shift the dialog 2 pixels away from the border */
   position_dialog (the_dialog, 2, 2);

   log_box[0]='\0';
   breakpoint_str[0]='\0';
   mmu_box[0]='\0';
   disass_debugger();
   regs_debugger();
   /* do the dialog */
   do_dialog(the_dialog, -1);
}

int main() {
    char buf[256];
    int i;
	init();
    MemInit();

   log_box[0]='\0';

    HWReset();
    debugger();
	while (!key[KEY_ESC]) {
          for (i=0;i<20000;i++)
          {
              log_box[0]='\0';
              CPUStep();
          }
          redraw_lisa();
	}

	deinit();
	return 0;
}
END_OF_MAIN()

void init() {
	int depth, res;
	allegro_init();
	depth = desktop_color_depth();
	if (depth == 0) depth = 32;
	set_color_depth(depth);
	res = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 720, 360, 0, 0);
	if (res != 0) {
		allegro_message(allegro_error);
		exit(-1);
	}

	install_timer();
	install_keyboard();
	install_mouse();
	/* add other initializations here */
}

void deinit() {
	clear_keybuf();
	/* add other deinitializations here */
}
